function [fuelFlwRate, engUnfeas, engPrf] = engineModel(engSpd, engTrq, eng)

engSpd = engSpd.*ones(size(engTrq)); % rad/s

% Engine state (0 - off, 1 - on)
engState = engSpd > 0;

% Maximum engine torque
engMaxTrq = eng.maxTrq(engSpd); % Nm
% Motoring torque
if isfield(eng, "motTrq")
    engMotTrq = eng.motTrq(engSpd); % Nm
else
    engMotTrq = zeros(size(engSpd)); % Nm
end

% Fuel and emissions mass flow rate
fuelFlwRate = eng.fuelFlwRate(engSpd, engTrq); % kg/s

if isfield(eng, 'NOx')
    noxFlwRate = eng.NOx(engSpd, engTrq); % kg/s
else
    noxFlwRate = zeros(size(fuelFlwRate));
end
if isfield(eng, 'exhFlwRate')
    exhFlwRate = eng.exhFlwRate(engSpd, engTrq); % kg/s
else
    exhFlwRate = zeros(size(fuelFlwRate));
end 
if isfield(eng, 'exhTemp')
    exhTemp = eng.exhTemp(engSpd, engTrq); % K
else
    exhTemp = zeros(size(fuelFlwRate));
end

fuelFlwRate(~engState) = 0;
noxFlwRate(~engState) = 0;
exhFlwRate(~engState) = 0;
exhTemp(~engState) = 293.15;

% Apply fuel correction factor
if isfield(eng, 'corrFactor')
    fuelFlwRate = fuelFlwRate .* eng.corrFactor.total; % kg/s
end

% Costraints
engSpdUnfeas = ( engTrq > 0 & engSpd < eng.idleSpd ) | ( engTrq>0 & engSpd > eng.maxSpd );
engTrqUnfeas = ( engTrq > engMaxTrq ) | ( engTrq < engMotTrq ); 
engUnfeas = ( engSpdUnfeas | engTrqUnfeas );

%% Pack profiles
engPrf.engSpd = engSpd;
engPrf.engTrq = engTrq;

engPrf.fuelFlwRate = fuelFlwRate;
engPrf.noxFlwRate = noxFlwRate;
engPrf.exhFlwRate = exhFlwRate;
engPrf.exhTemp = exhTemp;

engPrf.engMaxTrq = engMaxTrq;
engPrf.engMotTrq = engMotTrq;


engPrf.engSpdUnfeas = engSpdUnfeas;
engPrf.engTrqUnfeas = engTrqUnfeas;

end